define(['angular', 'app', 'formatter'], function (angular, app) {
	'use strict';

	app.controller('TrackersNotificationStatusController', function ($scope, $q, $state, $stateParams, TrackersRemindersService, TrackersConstants) {

        var detailsReady = $q.defer();
        
        $scope.sectionTitle = TrackersConstants[$stateParams.section].name;

        TrackersRemindersService.init($stateParams.section);
        TrackersRemindersService.getReminder($scope.sectionTitle).then(function (response) {
            $scope.details = angular.copy(response);
            detailsReady.resolve();
        });

        $scope.section = $stateParams.section;

        $scope.entryForm = {
            service: TrackersRemindersService,
            callbacks: {
                common: function () {
                    $state.go($state.current.data.backState, $stateParams);
                }
            },
            allowedActions: {
                save: true,
                cancel: true
            }
        };

        $scope.$watch('details.notificationStatus', function (status) {
            if (status !== "On" && $scope.details) {
                $scope.details.eventDate = "";
                $scope.details.frequency = "";
                $scope.details.times = [{value: ""}];
                $scope.details.notificationTypes = [];
            }
        });
    });
});